class BidentifierMwir():
    def __init__(self, daemon, ip, username, password):
        self.daemon = daemon
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "BidentifierMwir"},
            {"type": "dict", "value": {
                "ip": ip,
            "username": username,
            "password": password
        }}
        ])

        self.id = res["reference_id"]

    def get_sensor_id(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_sensor_id"},
            {"type": "list", "value": []} 
        ])

        return res["sensor-id"]

    def one_point_nuc(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "one_point_nuc"},
            {"type": "list", "value": []} 
        ], 60)

    def one_point_nuc_defocus(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "one_point_nuc_defocus"},
            {"type": "list", "value": []} 
        ], 120)

    def set_nuc(self, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot}
            ]} 
        ])

    def save_nuc(self, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "save_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot}
            ]} 
        ])

    def restore_nuc(self, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "restore_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot}
            ]} 
        ])

    def two_point_nuc_low(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_low"},
            {"type": "list", "value": []} 
        ], 60)

    def two_point_nuc_high(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_high"},
            {"type": "list", "value": []} 
        ], 60)

    def two_point_nuc_calc(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_calc"},
            {"type": "list", "value": []} 
        ], 60)

    def download_nuc_raw(self, low_path:str, high_path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nuc_raw"},
            {"type": "list", "value": [
                {"type": "string", "value": low_path},
                {"type": "string", "value": high_path}
            ]} 
        ], 60)

    def download_raw(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_raw"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ], 60)

    def download_nbc(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nbc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ], 60)

    def download_nuc(self, path:str, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nuc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
                {"type": "int", "value": slot },
            ]} 
        ], 60)

    def upload_nuc(self, path:str, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "upload_nuc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
                {"type": "int", "value": slot },
            ]} 
        ], 60)

    def copy_nuc(self, src_slot:int, dst_slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "copy_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": src_slot },
                {"type": "int", "value": dst_slot },
            ]} 
        ])

    def set_fov(self, fov:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_fov"},
            {"type": "list", "value": [
                {"type": "int", "value": fov },
            ]} 
        ])

    def get_lens_position(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_lens_position"},
            {"type": "list", "value": []} 
        ])

    
    def set_zoom_position(self, pos:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_zoom_position"},
            {"type": "list", "value": [
                 {"type": "int", "value": pos },
            ]} 
        ])

    def set_focus_position(self, pos:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_focus_position"},
            {"type": "list", "value": [
                 {"type": "int", "value": pos },
            ]} 
        ])

    def get_image_processing_status(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_image_processing_status"},
            {"type": "list", "value": [
            ]} 
        ])

    def set_integration_time(self, it:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_integration_time"},
            {"type": "list", "value": [
                {"type": "int", "value": it },
            ]} 
        ])
   
    def get_integration_time(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_integration_time"},
            {"type": "list", "value": []} 
        ])

        return res["integration-time"]

    def set_fps(self, fps:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_fps"},
            {"type": "list", "value": [
                {"type": "int", "value": fps },
            ]} 
        ])

    def get_fps(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_fps"},
            {"type": "list", "value": []} 
        ])

        return res["fps"]

    



