class MotorRail():
    def __init__(self, daemon, serial:str):
        self.daemon = daemon
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "MotorRail"},
            {"type": "dict", "value": {
                "serialNumber": serial
        }}], 180)

        self.id = res["reference_id"]

    def get_pos(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_position"},
            {"type": "list", "value": []} 
        ])
        return res["position"]

    def set_pos(self, position:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_position"},
            {"type": "list", "value": [
                {"type": "float", "value": position }
            ]} 
        ], 60)
        
    def reset_pos(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "reset_position"},
            {"type": "list", "value": [
            ]} 
        ])

    def get_info(self):
        return  self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_info"},
            {"type": "list", "value": [
            ]} 
        ])
    
    def set_platform_speed(self, speed:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_platform_speed"},
            {"type": "list", "value": [
                {"type": "int", "value": speed }
            ]} 
        ])

class DummyMotorRail:
    def __init__(self, serial="DUMMY-MOTOR-01"):
        self.serial = serial
        self.pos = 0.0

    def set_pos(self, position):
        time.sleep(0.1)
        self.pos = position

    def get_pos(self):
        return self.pos

    def reset_pos(self):
        self.pos = 0.0

    def get_info(self):
        return {
            "serial-number": self.serial,
            "platform-speed": 1,
            "calibration-unit": "mm",
            "min-position": 0.0,
            "max-position": 1000.0,
            "resolution": 0.1
        }

    def set_platform_speed(self, speed):
        pass




