from datetime import datetime
import time

def log(log_file:str, msg:str):
    timestamp = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    with open(log_file, "a") as f:
        f.write(f"[{timestamp}]: {msg}"+"\n")

    print(msg)

def sleep(log_file:str, seconds:float):
    log(log_file, f"Sleeping for {seconds}s ...")
    time.sleep(seconds)
    log(log_file, "Sleep done!")

