from datetime import datetime

class BidentifierMwir():
    def __init__(self, daemon, ip, username, password, port=22):
        self.daemon = daemon
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "BidentifierMwir"},
            {"type": "dict", "value": {
                "ip": ip,
                "username": username,
                "password": password,
                "port": port
        }}])

        self.id = res["reference_id"]

    def get_sensor_id(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_sensor_id"},
            {"type": "list", "value": []} 
        ])

        return res["sensor-id"]

    def one_point_nuc(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "one_point_nuc"},
            {"type": "list", "value": []} 
        ], 60)

    def one_point_nuc_defocus(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "one_point_nuc_defocus"},
            {"type": "list", "value": []} 
        ], 120)

    def set_nuc(self, slot:int, update:bool=True):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot},
                {"type": "int", "value": int(update)}
            ]} 
        ])

    def save_nuc(self, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "save_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot}
            ]} 
        ])

    def restore_nuc(self, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "restore_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": slot}
            ]} 
        ])

    def two_point_nuc_low(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_low"},
            {"type": "list", "value": []} 
        ], 60)

    def two_point_nuc_high(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_high"},
            {"type": "list", "value": []} 
        ], 60)

    def two_point_nuc_calc(self, save:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "two_point_nuc_calc"},
            {"type": "list", "value": [
                {"type": "int", "value": save},
            ]} 
        ], 120)

    def download_nuc_raw(self, low_path:str, high_path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nuc_raw"},
            {"type": "list", "value": [
                {"type": "string", "value": low_path},
                {"type": "string", "value": high_path}
            ]} 
        ], 60)

    def download_raw(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_raw"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ], 60)

    def download_nbc(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nbc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ], 60)

    def download_nuc(self, path:str, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nuc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
                {"type": "int", "value": slot },
            ]} 
        ], 60)

    def upload_nuc(self, path:str, slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "upload_nuc"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
                {"type": "int", "value": slot },
            ]} 
        ], 60)

    def copy_nuc(self, src_slot:int, dst_slot:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "copy_nuc"},
            {"type": "list", "value": [
                {"type": "int", "value": src_slot },
                {"type": "int", "value": dst_slot },
            ]} 
        ])

    def set_fov(self, fov:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_fov"},
            {"type": "list", "value": [
                {"type": "int", "value": fov },
            ]} 
        ])

    def get_lens_position(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_lens_position"},
            {"type": "list", "value": []} 
        ])

    
    def set_zoom_position(self, pos:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_zoom_position"},
            {"type": "list", "value": [
                 {"type": "int", "value": pos },
            ]} 
        ])

    def set_focus_position(self, pos:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_focus_position"},
            {"type": "list", "value": [
                 {"type": "int", "value": pos },
            ]} 
        ])

    def get_image_processing_status(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_image_processing_status"},
            {"type": "list", "value": [
            ]} 
        ])

    def set_integration_time(self, it:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_integration_time"},
            {"type": "list", "value": [
                {"type": "int", "value": it },
            ]} 
        ])
   
    def get_integration_time(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_integration_time"},
            {"type": "list", "value": []} 
        ])

        return res["integration-time"]

    def set_fps(self, fps:int):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_fps"},
            {"type": "list", "value": [
                {"type": "int", "value": fps },
            ]} 
        ])

    def get_fps(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_fps"},
            {"type": "list", "value": []} 
        ])
        return res["fps"]

    def set_digital_zoom(self, zoom:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_digital_zoom"},
            {"type": "list", "value": [
                {"type": "float", "value": zoom },
            ]} 
        ])

    def get_package_version(self):
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_package_version"},
            {"type": "list", "value": []} 
        ])

        return res["package-version"]

    def get_temperatures(self):
        return self.daemon.send_command("execute", 
            [
                {"type": "string", "value": self.id},
                {"type": "string", "value": "get_temperatures"},
                {"type": "list", "value": []} 
            ])

    def set_display_enable(self, enable:int):
        return self.daemon.send_command("execute", 
            [
                {"type": "string", "value": self.id},
                {"type": "string", "value": "set_display_enable"},
                {"type": "list", "value": [
                    {"type": "int", "value": enable}
                ]}
            ])
    
    def set_config(self, file_path:str):
        return self.daemon.send_command("execute", 
            [
                {"type": "string", "value": self.id},
                {"type": "string", "value": "set_sensor_config"},
                {"type": "list", "value": [
                    {"type": "string", "value": file_path}
                ]}
            ])

    def download_snapshot(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_snapshot"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ], 15)

    def download_table(self, path:str):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "download_nuc_table"},
            {"type": "list", "value": [
                {"type": "string", "value": path },
            ]} 
        ])

    def clean_ecc(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "clean_ecc"},
            {"type": "list", "value": [
            ]} 
        ])

    def set_clock(self, date:datetime=None):
        # set if not supplied
        if not date:
            date = datetime.now()
         
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_clock"},
            {"type": "list", "value": [
                {"type": "int", "value": date.year},
                {"type": "int", "value": date.month},
                {"type": "int", "value": date.day},
                {"type": "int", "value": date.hour},
                {"type": "int", "value": date.minute},
            ]} 
        ])

 

class DummyBidentifierMwir:
    def __init__(self, ip, username, password, port=22):
        self.ip = ip
        self.slot = 0
        self.int_time = 6000
        self.fps = 30
        self.fov = 3

    def set_fov(self, fov):
        self.fov = fov

    def set_zoom_position(self, pos):
        pass

    def set_focus_position(self, pos):
        pass

    def set_fps(self, fps):
        self.fps = fps

    def get_fps(self):
        return self.fps

    def set_integration_time(self, it):
        self.int_time = it

    def get_integration_time(self):
        return self.int_time

    def get_temperatures(self):
        return {
            "core": 40.0,
            "lens-driver": 35.0,
            "carrier": 42.0,
            "sensor-ambient": 25.0,
            "sensor-internal": 260.0
        }

    def get_sensor_id(self):
        return "DUMMY-ID-123"

    def get_package_version(self):
        return "1.0.0"

    def get_lens_position(self):
        return {
            "zoom": 1234,
            "focus": 5678,
            "temperature": 30.5
        }

    def get_image_processing_status(self):
        return {
            "tail-rejection-low": 1000,
            "tail-rejection-high": 6400,
            "agl-low": 0,
            "agl-high": 0,
            "histogram-low": 500,
            "histogram-high": 7500,
            "average": 3500,
            "offset": 0,
            "digital-zoom": 1.0,
            "current-nuc": self.slot,
            "raw-tail-rejection-low": 1000 + random.randint(-50, 50),
            "raw-tail-rejection-high": 6400 + random.randint(-50, 50),
            "raw-max-peak": 8192
        }

    def set_nuc(self, slot, update=True):
        self.slot = slot

    def two_point_nuc_high(self):
        pass

    def two_point_nuc_low(self):
        pass

    def two_point_nuc_calc(self, save):
        pass

    def download_nuc(self, path, slot):
        with open(path, 'w') as f:
            f.write(f"Dummy NUC data for slot {slot}")

    def download_nbc(self, path):
        with open(path, 'w') as f:
            f.write("Dummy NBC data")

    def download_snapshot(self, path):
        with open(path, 'w') as f:
            f.write("Dummy Snapshot")

    def download_table(self, path):
        with open(path, 'w') as f:
            f.write("Dummy NUC Table")

    def set_display_enable(self, enable):
        pass

    def set_config(self, path):
        pass
    
    def clean_ecc(self):
        pass

    def set_clock(self, date:datetime=None):
        pass

    



