# cc_dummy.py

import time
import random

class DummyBlackBody:
    def __init__(self, serial_number, threshold=1.0):
        self.serial = serial_number
        self.threshold = threshold
        self.mode = None
        self.abs_temp = 25.0
        self.diff_temp = 0.0
        self.bg_temp = 20.0

    def set_abs_temperature(self, temp, block=False):
        self.mode = "absolute"
        self.abs_temp = temp
        if block:
            self._simulate_delay()

    def set_diff_temperature(self, temp, block=False):
        self.mode = "differential"
        self.diff_temp = temp
        self.abs_temp = self.bg_temp + temp
        if block:
            self._simulate_delay()

    def stop_emitter(self):
        self.mode = "standby"
        self.abs_temp = self.bg_temp

    def get_emiter_temperature(self):
        return self.abs_temp

    def get_background_temperature(self):
        return self.bg_temp

    def get_info(self):
        return {
            "serial": self.serial,
            "model": "DummyBB-3000",
            "version": "1.0.0",
            "absolute-range": "-10 to 80",
            "differential-range": "-10 to 40"
        }

    def _simulate_delay(self):
        time.sleep(0.1)


class DummyClimateChamber:
    def __init__(self, ip=None, port=None, threshold=1.0):
        self.temp = 20.0
        self.humidity = 20.0
        self.running = False
        self.ip = ip
        self.port = port
        self.threshold = threshold


    def start(self, temp, hum, block=False):
        self.temp = temp
        self.humidity = hum
        self.running = True
        if block:
            time.sleep(0.2)

    def stop(self):
        self.running = False

    def get_status(self):
        return {"temperature": self.temp, "humidity": self.humidity}

    def get_device_info(self):
        return {
            "serial-number": "DUMMY-CC-001",
            "server-version": "1.0.0",
            "system-type": "DummyChamber"
        }


class DummyMotorRail:
    def __init__(self, serial="DUMMY-MOTOR-01"):
        self.serial = serial
        self.pos = 0.0

    def set_pos(self, position):
        time.sleep(0.1)
        self.pos = position

    def get_pos(self):
        return self.pos

    def reset_pos(self):
        self.pos = 0.0

    def get_info(self):
        return {
            "serial-number": self.serial,
            "platform-speed": 1,
            "calibration-unit": "mm",
            "min-position": 0.0,
            "max-position": 1000.0,
            "resolution": 0.1
        }

    def set_platform_speed(self, speed):
        pass


class DummyBidentifierMwir:
    def __init__(self, ip, username, password, port=22):
        self.ip = ip
        self.slot = 0
        self.int_time = 6000
        self.fps = 30
        self.fov = 3

    def set_fov(self, fov):
        self.fov = fov

    def set_zoom_position(self, pos):
        pass

    def set_focus_position(self, pos):
        pass

    def set_fps(self, fps):
        self.fps = fps

    def get_fps(self):
        return self.fps

    def set_integration_time(self, it):
        self.int_time = it

    def get_integration_time(self):
        return self.int_time

    def get_temperatures(self):
        return {
            "core": 40.0,
            "lens-driver": 35.0,
            "carrier": 42.0,
            "sensor-ambient": 25.0,
            "sensor-internal": 260.0
        }

    def get_sensor_id(self):
        return "DUMMY-ID-123"

    def get_package_version(self):
        return "1.0.0"

    def get_lens_position(self):
        return {
            "zoom": 1234,
            "focus": 5678,
            "temperature": 30.5
        }

    def get_image_processing_status(self):
        return {
            "tail-rejection-low": 1000,
            "tail-rejection-high": 6400,
            "agl-low": 0,
            "agl-high": 0,
            "histogram-low": 500,
            "histogram-high": 7500,
            "average": 3500,
            "offset": 0,
            "digital-zoom": 1.0,
            "current-nuc": self.slot,
            "raw-tail-rejection-low": 1000 + random.randint(-50, 50),
            "raw-tail-rejection-high": 6400 + random.randint(-50, 50),
            "raw-max-peak": 8192
        }

    def set_nuc(self, slot, update=True):
        self.slot = slot

    def two_point_nuc_high(self):
        pass

    def two_point_nuc_low(self):
        pass

    def two_point_nuc_calc(self, save):
        pass

    def download_nuc(self, path, slot):
        with open(path, 'w') as f:
            f.write(f"Dummy NUC data for slot {slot}")

    def download_nbc(self, path):
        with open(path, 'w') as f:
            f.write("Dummy NBC data")

    def download_snapshot(self, path):
        with open(path, 'w') as f:
            f.write("Dummy Snapshot")

    def download_table(self, path):
        with open(path, 'w') as f:
            f.write("Dummy NUC Table")

    def set_display_enable(self, enable):
        pass

    def set_config(self, path):
        pass



def LOG(msg):
    timestamp = time.strftime('%Y-%m-%d %H:%M:%S')
    log_line = f"[{timestamp}] {msg}"
    print(log_line)
    try:
        with open("dummy_log.txt", "a") as f:
            f.write(log_line + "\\n")
    except Exception as e:
        print(f"[LOG ERROR] Could not write to log file: {e}")
        

def SLEEP(seconds):
    import time
    time.sleep(seconds)