import time

class BlackBody():
    def __init__(self, daemon, serial_number:str, threshold:float=1):
        self.daemon = daemon
        self.serial_number = serial_number
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "BlackBody"},
            {"type": "dict", "value": {
                "serialNumber": serial_number,
        }}], 240)

        self.id = res["reference_id"]
        self.threshold = threshold

    def get_emiter_temperature(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_emiter_temperature"},
            {"type": "list", "value": []}
        ])
        return res["temperature"]
    
    def get_background_temperature(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_background_temperature"},
            {"type": "list", "value": []} 
        ])
        return res["temperature"]

    def set_abs_temperature(self, temperature:float, block=False):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_abs_temperature"},
            {"type": "list", "value": [
                {"type": "float", "value": temperature }
            ]} 
        ])

        if not block:
            return

        current = self.get_emiter_temperature()
        while not (temperature - self.threshold < current < temperature + self.threshold):
            print(f"BB waiting for ABS cmd to complete, target: {temperature}, current: {current}")
            time.sleep(1)
            current = self.get_emiter_temperature()
        print("BB target reached!.")

    def set_diff_temperature(self, temperature:float, block=False):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_diff_temperature"},
            {"type": "list", "value": [
                {"type": "float", "value": temperature }
            ]}
        ])

        if not block:
            return
            
        bg = self.get_background_temperature()
        emitter = self.get_emiter_temperature()
        diff = emitter - bg
        while not (temperature - self.threshold < diff < temperature + self.threshold):
            time.sleep(1)
            print(f"BB waiting for DIFF cmd to complete, diff-target: {temperature}, emitter: {emitter}, background: {bg}")
            bg = self.get_background_temperature()
            emitter = self.get_emiter_temperature()
            diff = emitter - bg
        print("BB target reached!.")
        
    def stop_emitter(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "stop_emitter"},
            {"type": "list", "value": [
            ]} 
        ])
    