class MotorRail():
    def __init__(self, daemon, serial:str):
        self.daemon = daemon
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "MotorRail"},
            {"type": "dict", "value": {
                "serialNumber": serial
        }}], 180)

        self.id = res["reference_id"]

    def get_pos(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_position"},
            {"type": "list", "value": []} 
        ])
        return res["position"]

    def set_pos(self, position:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_position"},
            {"type": "list", "value": [
                {"type": "float", "value": position }
            ]} 
        ])
        
    def reset_pos(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "reset_position"},
            {"type": "list", "value": [
            ]} 
        ])

    def get_info(self):
        return  self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_info"},
            {"type": "list", "value": [
            ]} 
        ])



