class ClimateChamber():
    def __init__(self, daemon, ip:str, port:int):
        self.daemon = daemon
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "ClimateChamber"},
            {"type": "dict", "value": {
                "ip": ip,
                "port": port
        }}])

        self.id = res["reference_id"]


    def start(self, temp:float, hum:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "start"},
            {"type": "list", "value": [
                {"type": "float", "value": temp},
                {"type": "float", "value": hum},
            ]} 
        ])

    def stop(self):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "stop"},
            {"type": "list", "value": [
            ]} 
        ])

    def get_status(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_status"},
            {"type": "list", "value": []} 
        ])

    def get_device_info(self):
        return self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_info"},
            {"type": "list", "value": []} 
        ])