blackbody = BlackBody("12345")  # Replace with actual serial number

LOG("Testing BlackBody device")

# Get initial temperatures
initial_emitter_temp = blackbody.get_emiter_temperature()
initial_background_temp = blackbody.get_background_temperature()
LOG(f"Initial Emitter Temp: {initial_emitter_temp}")
LOG(f"Initial Background Temp: {initial_background_temp}")

# Set absolute temperature
target_temp_abs = 50.0
blackbody.set_abs_temperature(target_temp_abs)
LOG(f"Set absolute temperature to {target_temp_abs}C")

# Verify absolute temperature
SLEEP(60)
current_emitter_temp = blackbody.get_emiter_temperature()
LOG(f"Current Emitter Temp: {current_emitter_temp}")

# Set differential temperature
target_temp_diff = 10.0
blackbody.set_diff_temperature(target_temp_diff)
LOG(f"Set differential temperature to {target_temp_diff}C")

# Verify differential temperature
SLEEP(60)
current_emitter_temp = blackbody.get_emiter_temperature()
LOG(f"Current Emitter Temp: {current_emitter_temp}")

# Stop emitter
blackbody.stop_emitter()
LOG("Stopped BlackBody emitter")

# Final check
SLEEP(60)
final_emitter_temp = blackbody.get_emiter_temperature()
LOG(f"Final Emitter Temp: {final_emitter_temp}")
