class BlackBody():
    def __init__(self, daemon, serial_number:str):
        self.daemon = daemon
        self.serial_number = serial_number
        res = self.daemon.send_command("open", [
            {"type": "string", "value": "BlackBody"},
            {"type": "dict", "value": {
                "serialNumber": serial_number,
        }}])

        self.id = res["reference_id"]

    def get_emiter_temperature(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_emiter_temperature"},
            {"type": "list", "value": []} 
        ])
        return res["temperature"]
    
    def get_background_temperature(self):     
        res = self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "get_background_temperature"},
            {"type": "list", "value": []} 
        ])
        return res["temperature"]

    def set_abs_temperature(self, temperature:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_abs_temperature"},
            {"type": "list", "value": [
                {"type": "float", "value": temperature }
            ]} 
        ])

    def set_diff_temperature(self, temperature:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "set_diff_temperature"},
            {"type": "list", "value": [
                {"type": "float", "value": temperature }
            ]} 
        ])
        
    def stop_emiter(self, temperature:float):
        self.daemon.send_command("execute", 
        [
            {"type": "string", "value": self.id},
            {"type": "string", "value": "stop_emiter"},
            {"type": "list", "value": [
            ]} 
        ])
    