# Master-Daemon Communication Protocol

This document describes the JSON-based protocol used for communication between a **Master** program and a **Daemon** program. The Master sends commands, and the Daemon executes them and returns responses.

---

## Message Types
1. **Command**: Sent by the Master to request an action.
2. **Response**: Sent by the Daemon to acknowledge command execution and return results/errors.

---

## Command Structure (Master → Daemon)
Commands are JSON objects with the following fields:
- `type`: Always `"command"`.
- `id`: A UUID to uniquely identify the command.
- `payload`: Contains action details:
  - `name`: The command name (e.g., `"open"`, `"close"`, `"execute"`).
  - `params`: A list of parameters, each specifying a `type` and `value`.

### Available Commands
#### 1. Create Device (`open`)
```json
{
  "type": "command",
  "id": "<command-UUID>",
  "payload": {
    "name": "open",
    "params": [
      {"type": "string", "value": "<device-type>"},
      {"type": "dict", "value": {
        "param-1-name": "<param-1-value>",
        "param-2-name": "<param-2-value>"
      }}
    ]
  }
}
```
#### 2. Execute Device Command (`execute`)
```json
{
  "id" : "<command-UUID>",
  "type": "command",
  "payload": {
    "name": "execute",
    "params": [
      {"type": "string", "value": "<device UUID>"},
      {"type": "string", "value": "<name-of-cmd>"},
      {"type": "list", "value": [
        {"type": "<type-of-param-1>", "value": "<value-of-param-1>"}
      ]}
    ]
  }
}
```

#### 3. Close Device (`close`)
```json
{
  "type": "command",
  "id" : "<command-UUID>",
  "payload": {
    "name": "close",
    "params": [
      {"type": "string", "value": "<UUID-of-closed-device>"}
    ]
  }
}
```
#### 4. Close All Device (`close_all`)
```json
{
  "type": "command",
  "id" : "<command-UUID>",
  "payload": {
    "name": "close_all",
    "params": [
    ]
  }
}
```

## Response Structure (Daemon → Master)
Responses are JSON objects with the following fields:
- type: Always "response".
- id: Matches the UUID from the corresponding command.
- data: Key-value pairs with execution results (omitted if status is error). Data is based on the specific command.
- status: Either "success" or "error".
- error: Error description (only present if status is "error").

#### 1. Example Response
```json
{
  "type": "response",
  "id": "<command UUID>",
  "data" : {
    "<data-key-1>" : "<data-value-1>"
  },
  "status" : "<error|success>",
  "error" : "<string description of error if there is any>"
}
```
