blackbody = BlackBody("TL2939")
#blackbody = Blackbody("TL2839")

LOG("Testing BlackBody device")

# Get device information
LOG("Device parameters:")
LOG(blackbody.get_info())

# Get initial temperatures
initial_emitter_temp = blackbody.get_emiter_temperature()
initial_background_temp = blackbody.get_background_temperature()
LOG(f"Initial Emitter Temp: {initial_emitter_temp}")
LOG(f"Initial Background Temp: {initial_background_temp}")

# Set absolute temperature
target_temp_abs = 35
blackbody.set_abs_temperature(target_temp_abs, True)
LOG(f"Set absolute temperature to {target_temp_abs}C")

# Verify absolute temperature
current_emitter_temp = blackbody.get_emiter_temperature()
LOG(f"Current Emitter Temp: {current_emitter_temp}")

# Set differential temperature
target_temp_diff = 10.0
blackbody.set_diff_temperature(target_temp_diff, True)
LOG(f"Set differential temperature to {target_temp_diff}C")

# Verify differential temperature
current_emitter_temp = blackbody.get_emiter_temperature()
LOG(f"Current Emitter Temp: {current_emitter_temp}")

# Stop emitter
blackbody.stop_emitter()
LOG("Stopped BlackBody emitter")

# Final check
for i in range (0, 3):
    LOG(f"Current Emitter Temp: {blackbody.get_emiter_temperature()}")
    SLEEP(60)

LOG(f"Final Emitter Temp: {blackbody.get_emiter_temperature()}")

