import os, sys, traceback, base64, json, logging, subprocess, re
from logging.handlers import RotatingFileHandler
from datetime import datetime
from inspect import ismethod


### Logging ###
log_formatter = logging.Formatter('%(asctime)s - %(message)s')

rotate_handler = RotatingFileHandler("/var/log/axion-translator.log", mode='a', maxBytes=10*1024*1024, backupCount=10, encoding=None, delay=0)
rotate_handler.setFormatter(log_formatter)
rotate_handler.setLevel(logging.INFO)

loggger = logging.getLogger()
loggger.setLevel(logging.INFO)
loggger.addHandler(rotate_handler)

################


def printout(message):
    try:
        print('{0} - {1}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S"), message))
        loggger.info(message)

    except Exception as e:
        print(str(e))
        print(traceback.format_exc())

def get_local_path(*path):
    try:
        return os.path.abspath(os.path.join(os.path.dirname(__file__), "..", *path))

    except Exception as e:
        printout(str(e))
        printout(traceback.format_exc())

def bytes_to_int(data):
    try:
        result = 0
        for bt in data: result = result * 256 + int(bt)

        return result

    except Exception as e:
        printout(str(e))
        printout(traceback.format_exc())

def int_to_bytes(value, length):
    try:
        result = []
        for i in range(0, length): result.append(value >> (i * 8) & 0xff)
        result.reverse()

        return result

    except Exception as e:
        printout(str(e))
        printout(traceback.format_exc())

def delete_file(path):
    try:
        os.remove(path)
    except Exception as e:
        pass

def method_exists(instance, method):
    return hasattr(instance, method) and ismethod(getattr(instance, method))

def json_converter(o):
    if isinstance(o, datetime):
        return o.__str__()
    else:
        if method_exists(o, "to_json"):
            return o.to_json()
        else:
            return o.__dict__

def json_to_str(obj):
    try:
        return json.dumps(obj, default = json_converter)

    except Exception as e:
        printout(str(e))
        printout(traceback.format_exc())

    return "{}"

def convert_to_base64(data):
    try:
        return base64.b64encode(data.encode("ascii")).decode("ascii")

    except Exception as e:
        printout(str(e))
        printout(traceback.format_exc())

def remove_non_ascii(text):
    return re.sub(r'[^\x00-\x7F]', ' ', text)

def get_value_brt(bt):
    int_value = int(format(bt, '02x'), 16)
    if int_value > 127:
        signed_value = -((~int_value & 0xFF) + 1)
    else:
        signed_value = int_value

    return signed_value

def get_value_cnt(bt):
    int_value = int(format(bt, '02x'), 16)
    return int_value

def get_mac_address(interface="eth0"):
    try:
        return subprocess.getoutput("cat /sys/class/net/{}/address".format(interface))

    except Exception as e:
        printout(str(e))
        traceback.print_exc(file=sys.stdout)
        return ""

def get_ip_addresses():
    ip_addresses = {}

    # Run 'ip addr' to get all interface details
    result = subprocess.getoutput("ip addr")

    # Parse the output line by line
    lines = result.split('\n')
    interface = None

    for line in lines:
        # Match the interface name (e.g., "2: enp3s0:")
        if_match = re.match(r'\d+: ([\w\d]+):', line)
        if if_match:
            interface = if_match.group(1)

        # Match the IPv4 address (e.g., "inet 192.168.1.2/24")
        ip_match = re.search(r'inet (\d+\.\d+\.\d+\.\d+)', line)
        if ip_match and interface:
            if interface == "eth0":
                ip_addresses["lan"] = ip_match.group(1)
            elif interface == "wlan1":
                ip_addresses["wifi"] = ip_match.group(1)

    return ip_addresses