import os, json, traceback, threading, time, libconf
from time import sleep

from app.utility import *
from app.network.server.websocket.server import *


class WsHandle(object):

    def __init__(self, manager):
        self.m = manager
        self.clients = []
        self.has_clients = False
        
        # Threads
        threading.Thread(target=self.keep_alive, daemon=True).start()
        
    # Keep-Alive
    def keep_alive(self):
        while not self.m.exit:
            sleep(1)
            
            try:
                self.has_clients = len(self.clients) > 0
                
                # Check if clients are still connected
                for client in self.clients:
                    passed = time.monotonic() - client['timestamp']
                    if passed > 8: self.clients.remove(client)

            except Exception as e:
                printout(str(e))
                printout(traceback.format_exc())  
                
    # incoming data from all web clients
    def receive(self, client, data):
        try:
            
            # Clients
            web_client = [item for item in self.clients if item['address'] == client.address[0]]
            if web_client:
                web_client = web_client[0]
                web_client['timestamp'] = time.monotonic()
                
            else:
                self.clients.append({ 'address': client.address[0], 'client': client, 'timestamp': time.monotonic() })
                
            self.has_clients = len(self.clients) > 0
            
            # Data
            recv = json.loads(data)
            if "channel" in recv and "data" in recv:
                
                # + {"channel":"APP.GET","data":{}}
                # {"channel":"UPD.VERSION","data":{}}
                # + {"channel":"UPD.GETID.MAKE","data":{}}
                # + {"channel":"OSD.STRM.MAKE","data":{"strm_en":1}}
                # + {"channel":"MCU.BATT_LEVEL.FETCH","data":{}}
                # + {"channel":"MEDIA.CHECK.MAKE","data":{}}
                # + {"channel":"OSD.CALENDAR.FETCH","data":{}}
                # + {"channel":"OSD.TIME.FETCH","data":{}}
                
                # + {"channel":"TCORE.BRT.MAKE","data":{"BRT":{"range":[-50,50],"step":5,"current":-5}}}
                # + {"channel":"TCORE.CONT.MAKE","data":{"CONT":{"range":[40,80],"step":5,"current":60}}}
                # + {"channel":"TCORE.WEATHER.MAKE","data":{"WEATHER":{"current":"normal","type_list":["hot","normal","wet"]}}}
                # + {"channel":"TCORE.FILTER.MAKE","data":{"FILTER":{"current":"on","type_list":["on","off"]}}}
                # + {"channel":"TCORE.PALETTE.MAKE","data":{"PALETTE":{"current":"RH","type_list":["BH","WH"]}}}
                # + {"channel":"TCORE.NUC_TYPE.MAKE","data":{"NUC_TYPE":{"current":"EXT","time":2,"type_list":["INT","EXT"]}}}
                # + {"channel":"OSD.STANDBY.MAKE","data":{"STANDBY":{"current":"OFF"}}}

                # APP GET
                if recv['channel'] == "APP.GET":
                    self.send_all({ "channel": "APP.UPDATE", "data": self.m.bidentifier.get_app_update() })
                    
                # Update Get Id
                elif recv['channel'] == "UPD.GETID.MAKE": 
                    swcfg = None
                    with open('/settings/swupdate.cfg', 'r') as f: swcfg = libconf.load(f)
                    if swcfg:
                        self.send_all({ "channel": "UPD.GETID.DONE", "data": { "UPDATE": { "DeviceID": { "ID": swcfg['suricatta']['id'], "TargetToken": swcfg['suricatta']['targettoken'] }}}})
                    
                # Get Storage
                elif recv['channel'] == "MEDIA.CHECK.MAKE":
                    percent = self.m.bidentifier.get_storage_percent()
                    message = "Enough space"
                    code = 3
                    
                    if percent < 1:
                        message = "Critic space"
                        code = 1
                    elif percent >= 1 and percent <= 10:
                        message = "Out of Space"
                        code = 2
                    else:
                        message = "Enough  space"
                        code = 3
        
                    self.send_all({ "channel": "MEDIA.STORAGE.DONE", "data": { "message": message, "code": code, "free_space": percent } })
                  
                # Remove file  
                elif recv['channel'] == "OSD.FILEDEL.MAKE":
                    file = recv['data']['f_name']
                    _, ext = os.path.splitext(file)
                    if ext == ".mp4":
                        delete_file("/media/video/{}".format(file))
                        
                    elif ext == ".jpeg":
                        delete_file("/media/image/{}".format(file))
                        
                    self.send_all({ "channel": "OSD.FILEDEL.DONE", "data": {} })
                    
                # Set Calendar
                elif recv['channel'] == "OSD.CALENDAR.MAKE":
                    calendar = recv['data']['CALENDAR']
                    self.m.bidentifier.set_calendar(calendar)
                    self.send_all({ "channel": "OSD.CALENDAR.DONE", "data": {} })
                    
                # Set Time
                elif recv['channel'] == "OSD.TIME.MAKE":
                    time_set = recv['data']['TIME']
                    self.m.bidentifier.set_time(time_set)
                    self.send_all({ "channel": "OSD.TIME.DONE", "data": {} })
                    
                # Get Calendar
                elif recv['channel'] == "OSD.CALENDAR.FETCH":
                    self.send_all({ "channel": "OSD.CALENDAR.STATUS", "data": { "CALENDAR": self.m.bidentifier.get_calendar() } })
                    
                # Get Time
                elif recv['channel'] == "OSD.TIME.FETCH":
                    self.send_all({ "channel": "OSD.TIME.STATUS", "data": { "TIME": self.m.bidentifier.get_time() } })
                    
                # Stream on/off
                elif recv['channel'] == "OSD.STRM.MAKE":
                    strm_en = int(recv['data']['strm_en'])
                    self.m.bidentifier.set_stream(strm_en)
                    self.send_all({ "channel": "OSD.STRM.DONE", "data": {} })
                    
                # Snapshot
                elif recv['channel'] == "OSD.SNAPSHOT.MAKE":
                    self.m.bidentifier.snapshot()
                    self.send_all({ "channel": "OSD.SNAPSHOT.DONE", "data": {} })
                    
                # Record
                elif recv['channel'] == "OSD.REC.MAKE":
                    rec_en = int(recv['data']['rec_en'])
                    self.m.bidentifier.recording(rec_en)
                    self.send_all({ "channel": "OSD.REC.DONE", "data": {} })
                    
                # Brightness
                elif recv['channel'] == "TCORE.BRT.MAKE":
                    brt = recv['data']['BRT']['current']
                    self.m.bidentifier.set_brightness(brt)
                    self.send_all({ "channel": "TCORE.BRT.DONE", "data": {} })
                    
                # Contrast
                elif recv['channel'] == "TCORE.CONT.MAKE":
                    cont = recv['data']['CONT']['current']
                    self.m.bidentifier.set_contrast(cont)
                    self.send_all({ "channel": "TCORE.CONT.DONE", "data": {} })
                    
                # Weather
                elif recv['channel'] == "TCORE.WEATHER.MAKE":
                    weather = recv['data']['WEATHER']['current']
                    self.m.bidentifier.set_weather(weather)
                    self.send_all({ "channel": "TCORE.WEATHER.DONE", "data": {} })
                    
                # Filter
                elif recv['channel'] == "TCORE.FILTER.MAKE":
                    filter = recv['data']['FILTER']['current']
                    self.m.bidentifier.set_filter(filter)
                    self.send_all({ "channel": "TCORE.FILTER.DONE", "data": {} })

                # Palette
                elif recv['channel'] == "TCORE.PALETTE.MAKE":
                    palette = recv['data']['PALETTE']['current']
                    self.m.bidentifier.set_palette(palette)
                    self.send_all({ "channel": "TCORE.PALETTE.DONE", "data": {} })
                    
                # NUC
                elif recv['channel'] == "TCORE.NUC.MAKE":
                    self.m.bidentifier.set_nuc()
                    self.send_all({ "channel": "TCORE.NUC.DONE", "data": {} })
                    
                # NUC Type
                elif recv['channel'] == "TCORE.NUC_TYPE.MAKE":
                    nuc_type = recv['data']['NUC_TYPE']['current']
                    self.m.bidentifier.set_nuc_type(nuc_type)
                    self.send_all({ "channel": "TCORE.NUC_TYPE.DONE", "data": {} })
                    
                # Standby
                elif recv['channel'] == "OSD.STANDBY.MAKE":
                    standby = recv['data']['STANDBY']['current']
                    self.m.bidentifier.set_standby(standby)
                    self.send_all({ "channel": "OSD.STANDBY.DONE", "data": {} })
                    
                # ZOOM
                elif recv['channel'] == "TCORE.ZOOM.MAKE":
                    zoom = recv['data']['ZOOM']['current']
                    self.m.bidentifier.set_zoom(zoom)
                    self.send_all({ "channel": "TCORE.ZOOM.DONE", "data": {} })
                    
                # GPS (On)
                elif recv['channel'] == "GPS.ON.MAKE":
                    self.m.bidentifier.set_gps(True)
                    self.send_all({ "channel": "GPS.ON.DONE", "data": {} })
                    
                # GPS (Off)
                elif recv['channel'] == "GPS.OFF.MAKE":
                    self.m.bidentifier.set_gps(False)
                    self.send_all({ "channel": "GPS.OFF.DONE", "data": {} })
                    
                # DMC (On)
                elif recv['channel'] == "DMC.ON.MAKE":
                    self.m.bidentifier.set_dmc(True)
                    self.send_all({ "channel": "DMC.ON.DONE", "data": {} })
                    
                # DMC (Off)
                elif recv['channel'] == "DMC.OFF.MAKE":
                    self.m.bidentifier.set_dmc(False)
                    self.send_all({ "channel": "DMC.OFF.DONE", "data": {} })
                    
                # LRF (Measure distance)
                elif recv['channel'] == "LRF.MEASURE.MAKE":
                    self.m.bidentifier.lrf_measure()
                    self.send_all({ "channel": "LRF.MEASURE.DONE", "data": {} })
                    
                # Target Lock (On)
                elif recv['channel'] == "TARGET_LOCK.ON.MAKE":
                    self.m.bidentifier.set_target_lock(True)
                    self.send_all({ "channel": "TARGET_LOCK.ON.DONE", "data": {} })
                    
                # Target Lock (Off)
                elif recv['channel'] == "TARGET_LOCK.OFF.MAKE":
                    self.m.bidentifier.set_target_lock(False)
                    self.send_all({ "channel": "TARGET_LOCK.OFF.DONE", "data": {} })
                    
                # Target Lock (Confirm)
                elif recv['channel'] == "TARGET_LOCK.CONFIRM.MAKE":
                    self.m.bidentifier.target_lock_confirm()
                    self.send_all({ "channel": "TARGET_LOCK.CONFIRM.DONE", "data": {} })
                    
                # Target Lock (Refuse)
                elif recv['channel'] == "TARGET_LOCK.REFUSE.MAKE":
                    self.m.bidentifier.target_lock_refuse()
                    self.send_all({ "channel": "TARGET_LOCK.REFUSE.DONE", "data": {} })
                    
                # Target Lock (List)
                elif recv['channel'] == "TARGET_LOCK.LIST.MAKE":
                    tgt_list = self.m.bidentifier.get_target_lock_list()
                    self.send_all({ "channel": "TARGET_LOCK.LIST.DONE", "data": { "TARGETS": tgt_list }})
                    
                # Display on
                elif recv['channel'] == "DISPLAY.ON.MAKE":
                    self.m.bidentifier.set_display(True)
                    self.send_all({ "channel": "DISPLAY.ON.DONE", "data": {} })
                    
                # Display off
                elif recv['channel'] == "DISPLAY.OFF.MAKE":
                    self.m.bidentifier.set_display(False)
                    self.send_all({ "channel": "DISPLAY.OFF.DONE", "data": {} })
                    
                ### Zoom ###
                
                # Zoom In
                elif recv['channel'] == "ZOOM.ZOOM_IN.MAKE":
                    self.m.bidentifier.zoom_in()
                    self.send_all({ "channel": "ZOOM.ZOOM_IN.DONE", "data": {} })
                    
                # Zoom Out
                elif recv['channel'] == "ZOOM.ZOOM_OUT.MAKE":
                    self.m.bidentifier.zoom_out()
                    self.send_all({ "channel": "ZOOM.ZOOM_OUT.DONE", "data": {} })
                    
                # Zoom Stop
                elif recv['channel'] == "ZOOM.ZOOM_STOP.MAKE":
                    self.m.bidentifier.zoom_stop()
                    #self.m.bidentifier.get_zoom()
                    self.send_all({ "channel": "ZOOM.ZOOM_STOP.DONE", "data": { "ZOOM": self.m.bidentifier.base_obj['ZOOM'] }})
                    
                # Digital Zoom
                elif recv['channel'] == "ZOOM.DZOOM.MAKE":
                    zoom = recv['data']['ZOOM']['current']
                    self.m.bidentifier.digital_zoom(zoom)
                    self.send_all({ "channel": "ZOOM.DZOOM.DONE", "data": {} })
                
                ### Authentication ###
                
                elif recv['channel'] == "AUTH.CHECK.MAKE":
                    pin = recv['data']['PIN']
                    self.m.bidentifier.auth_pin(pin)
                    
                elif recv['channel'] == "AUTH.CHANGE_PIN.MAKE":
                    old_pin = recv['data']['OLD_PIN']
                    new_pin = recv['data']['NEW_PIN']
                    self.m.bidentifier.change_pin(old_pin, new_pin)
                    
                # elif recv['channel'] == "AUTH.RESET.MAKE":
                #     auth = self.m.bidentifier.reset_pin()
                #     self.send_all({ "channel": "AUTH.RESET.DONE", "data": {} })
                
        except (Exception, ValueError) as e:
            printout(str(e))
            printout(traceback.format_exc())  

    # Outgoing data to all web clients
    def send_all(self, data, clear=False):
        try:
            if not clear: data = json.dumps(data, default = json_converter)
            printout("Websocket: Sent All - {}".format(data))
            for desc, conn in self.m.ws_clients.items(): conn.sendMessage(data)

        except Exception as e:
            printout(str(e))
            printout(traceback.format_exc())  

    # Outgoing data to single client
    def send(self, client, data, clear=False):
        try:
            if not clear: data = json.dumps(data, default = json_converter)
            printout("Websocket: Sent - {}".format(data))
            client.sendMessage(data)

        except Exception as e:
            printout(str(e))
            printout(traceback.format_exc())  


class WBHandler(WebSocket):
    
    def handleMessage(self):
        try:
            printout("Websocket: Received - {}".format(self.data))
            self.m.ws_handle.receive(self, self.data)

        except Exception as e:
            printout(str(e))
            printout(traceback.format_exc())  

    def handleConnected(self):
        printout("Websocket: Client Connected")
        pass

    def handleClose(self):
        self.m.ws_clients.remove(self)
        printout("Websocket: Client Disconnected")
        pass
