import traceback, socket
from time import sleep

from app.utility import *


class UnixSocket(object):

    def __init__(self, path):
        self.path = path
        self.sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        self.sock.connect(path)

    def send(self, cmd):
        try:
            printout('Socket | Sent: {!r}'.format(cmd))
            self.sock.send(cmd.encode())
            
            data = self.sock.recv(1024)
            return data
            
        except Exception as e:
            printout(str(e))
            printout(traceback.format_exc())
            
            self.sock.close()
            sleep(2)
            self.sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
            self.sock.connect(self.path)
            
        except BrokenPipeError as bp:
            self.sock.close()
            sleep(2)
            self.sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
            self.sock.connect(self.path)
