#!/bin/bash

bin_name="axion-translator"
bin_dir="/opt/$bin_name"
usr_bin="/usr/bin/$bin_name"
secured=( "config.ini" )
root="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

f_install_systemd() {

    # install systemd
	cp -v "$bin_dir/$bin_name.service" "/lib/systemd/system/$bin_name.service"
	chmod -v 644 "/lib/systemd/system/$bin_name.service"

	systemctl daemon-reload

	# enable service
	systemctl enable "$bin_name.service"

	# start service
	systemctl start "$bin_name.service"
}

f_uninstall_systemd() {
    if [[ -e "/lib/systemd/system/$bin_name.service" ]] ; then
        systemctl stop "$bin_name.service"
        systemctl disable "$bin_name.service"

        rm -v "/lib/systemd/system/$bin_name.service"

        systemctl daemon-reload
    fi
}

f_install() {
	blacklist=( "index.html", "pack" )
	mk_dirs=( "$bin_dir" )
	access=(  )
	copies=( `ls -B` )

	# make directories
	for dir in "${mk_dirs[@]}" ; do
		if [[ ! -d "$dir" ]] ; then
			mkdir "$dir"

			# check if directory requires full access
			if [[ " ${access[*]} " == *" $dir "* ]] ; then
				chmod 777 -R "$dir"
			fi			
		fi		
	done

	# copy content
	for copy in "${copies[@]}" ; do		
		if [[ " ${blacklist[*]} " != *" $copy "* ]] ; then

		    # skip if secured
		    if [[ " ${secured[*]} " == *" $copy "* ]] ; then
		        if [[ -e "$copy " ]] ; then
                    continue
                fi
		    fi

			if [[ -d ./"$copy" && ! -d "$bin_dir/$copy" ]] ; then
				cp -v -r ./"$copy" "$bin_dir"
			else
				if [[ ! -f "$bin_dir/$copy" ]] ; then
					cp -v ./"$copy" "$bin_dir"
				fi				
			fi
		fi	
	done

	# setting mode
	chmod -v 755 "$bin_dir"/*.sh

	# symlink launcher
	ln -s "$bin_dir/$bin_name.sh" "$usr_bin"

	# install main service
	f_install_systemd
}

f_uninstall() {

	# uninstall service
    f_uninstall_systemd

	rm -v "$usr_bin"

	# delete directory content
    find "$bin_dir" -depth | while read file ; do
        protected_file=`basename "$file"`
        protected_dir=$(echo "$file" | cut -d "/" -f4)

        # skip if protected
        if [[ " ${secured[*]} " == *" $protected_file "* || " ${secured[*]} " == *" $protected_dir "* ]] ; then
            continue
        fi

        if [[ -d "$file" ]] ; then
            rmdir --verbose "$file"
        fi

        if [[ -f "$file" ]] ; then
            rm -v "$file"
        fi
    done
}

f_reinstall() {	

	# uninstall
	f_uninstall

	sleep 2

	# install
	f_install

	# wait a bit
	sleep 2

	# log
	f_log
}

f_log() {	
	journalctl -f -u "$bin_name.service"
}


if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root." 
   exit 1
fi

if [ $# -eq 0 -o $# -gt 1 ]; then
	echo "Usage: $(basename $0) <install|uninstall|reinstall>"
	exit 1
fi

for i in "$@" ; do
	case $i in
	    '-i' | '--install' | 'install')
	    f_install
	    shift
	    ;;
	    '-u' | '--uninstall' | 'uninstall')
	    f_uninstall
	    shift
	    ;;	 
		'-r' | '--reinstall' | 'reinstall')
	    f_reinstall
	    shift
	    ;;	    
	esac
done

exit "$?"
