import json

from app.utility import *


class Broadcast:
    def __init__(self, manager):
        self.transport = None
        self.m = manager
        
        printout("Broadcast: Server started...")

    def connection_made(self, transport):
        self.transport = transport

    def datagram_received(self, data, addr):
        msg = json.loads(data.decode())
        printout("Broadcast: Received request '{}' ({})".format(msg, addr))

        if "cmd" in msg:
            if msg['cmd'] == "ping":
                if self.m.bidentifier:
                    self.transport.sendto(json.dumps({ 
                        "cmd": "pong", 
                        "mac": get_mac_address("wlan1"), 
                        "ip": get_ip_addresses(),
                        "version": self.m.version,
                        "model": self.m.bidentifier.base_obj['MODEL']
                    }).encode(), addr)
